<?
/***************************************************/
/* premire tape : rcupratin du poids de l'image*/
/***************************************************/
$file_name = 'tux.jpg';
$file_size = filesize($file_name); //rcupration de la taille en octets
$file_size = round($file_size/1024); //conversion en ko


/***************************************************/
/* seconde tape : calcul des dimensions de la     */
/* nouvelle image comprenant contour + lgende     */
/***************************************************/
list($largeur, $hauteur) = getimagesize($file_name); //dimenseions de l'image originale

/***************************************************/
/* on veut une image rduite de 150px de large     */
/* sans compter les contours                       */
/* on doit donc diviser la largeur par 150         */
/* on passe  l'inverse car on multiplie par la    */
/* suite : cela vite un agrandissement            */
/***************************************************/
$ratio = 150/ $largeur; //ratio pour rduire  une taille voulue

$vignette_largeur = $largeur * $ratio + 2;  //on ajoute 2px  cause du contour

/* on ajoute 3px  cause du contour+lgende        */
/* imagefontheight retourne la hauteur en pixels   */
/* d'une police slectione : cela permet de       */
/* calculer la hauteur de la lgende               */
$vignette_hauteur = $hauteur * $ratio + 3 + imagefontheight(3);

$n_image_largeur = $largeur * $ratio; //largeur de l'image rduite
$n_image_hauteur = $hauteur * $ratio; //hauteur de l'image rduite


/***************************************************/
/* cration de la vignette : on attribue aucune    */
/* couleur pour laisser un cadre noir              */
/***************************************************/

$image = imagecreatetruecolor($vignette_largeur,$vignette_hauteur);

/***************************************************/
/* cration de la lgende : texte en blanc         */
/***************************************************/
$blanc = imagecolorallocate($image,255,255,255); //couleur blanche

$string = $largeur."x".$hauteur." ".$file_size."ko"; //cration du texte de lgende

/* on doit dterminer l'endroit pour commencer     */
/*  crire. On centre le texte d'o la            */
/* formulation plus complexe                       */

$write_h = $vignette_hauteur - imagefontheight(3) - 1; //hauteur
/* centrage -> on rcupre $n_largeur la largeur   */
/* de la vignette, on lui retire la largeur de la  */
/* police multiplie par le nombre de caractres   */
/* puis on divise le rsultat par 2 pour centrer   */
$write_w = ($vignette_largeur - strlen($string) * imagefontwidth(3))/2;

imagestring($image, 3, $write_w, $write_h, $string, $blanc); //on crit la lgende

/***************************************************/
/* ouverture du fichier                            */
/***************************************************/
$source = imagecreatefromjpeg($file_name);

/***************************************************/
/* rduction, rchantillonage et copie de l'image */
/* originale                                       */
/* on recopie l'image  partir du point de         */
/* coordonnes 1,1 pour laisser un cadre noir      */
/***************************************************/
imagecopyresampled($image,$source, 1,1, 0,0, $n_image_largeur , $n_image_hauteur , $largeur, $hauteur);

/***************************************************/
/* envoi de l'image et destruction                 */
/***************************************************/
header('Content-type: image/png');
imagepng($image);
imagedestroy($image);

/***************************************************/
/* c'est la fin ! un petit caf ?                  */
/***************************************************/
?>